unit DOsoba;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, Mask;

type
  TDlgOsoba = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    meNazwisko: TMaskEdit;
    meImie: TMaskEdit;
    meMcowosc: TMaskEdit;
    meUlicaINr: TMaskEdit;
    meKodP: TMaskEdit;
    meMiasto: TMaskEdit;
    mePesel: TMaskEdit;
    dtpDataUr: TDateTimePicker;
    Label8: TLabel;
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
    idosoby   : Integer;
    tryb_edit : Boolean;
  public
    { Public declarations }
    procedure  set_tryb(Value: Boolean);

    // pobiera dane z tabeli OSOBY
    function   get_idosoby() : Integer;
    function   get_nazwisko() : String;
    function   get_dataur() : TDateTime;
    function   get_mcowosc() : String;
    function   get_ulicainr() : String;
    function   get_kodp : String;
    function   get_miasto() : String;
    function   get_pesel() : String;

    // pobiera dane z kontrolek ekranowych
    function   gets_idosoby() : Integer;
    function   gets_nazwisko() : String;
    function   gets_imie() : String;
    function   gets_dataur() : TDateTime;
    function   gets_mcowosc() : String;
    function   gets_ulicainr() : String;
    function   gets_kodp : String;
    function   gets_miasto() : String;
    function   gets_pesel() : String;

    // ustawia kontrolki ekranowe
    procedure  set_idosoby(Value : Integer);
    procedure  set_nazwisko(Value: String);
    procedure  set_dataur(Value: TDateTime);
    procedure  set_mcowosc(Value: String);
    procedure  set_ulicainr(Value: String);
    procedure  set_kodp(Value: String);
    procedure  set_miasto(Value: String);
    procedure  set_pesel(Value: String);

    constructor Create(AOwner: TComponent; tryb: Boolean);
  end;

var
  DlgOsoba: TDlgOsoba;

implementation
{$R *.dfm}

uses
   DataModule;

constructor TDlgOsoba.Create(AOwner: TComponent; tryb: Boolean);
begin
   inherited Create(AOwner);
   set_tryb(tryb);

   if tryb_edit then begin
      set_idosoby(get_idosoby());
      set_nazwisko(get_nazwisko());
      set_dataur(get_dataur());
      set_mcowosc(get_mcowosc());
      set_ulicainr(get_ulicainr());
      set_kodp(get_kodp());
      set_miasto(get_miasto());
      set_pesel(get_pesel());
   end
   else begin
      set_idosoby(-1);
      set_nazwisko('');
      set_dataur(Now());
      set_mcowosc('');
      set_ulicainr('');
      set_kodp('');
      set_miasto('');
      set_pesel('');
   end;
end;

procedure TDlgOsoba.set_tryb(Value: Boolean);
begin
   tryb_edit := Value;
end;

function TDlgOsoba.get_idosoby() : Integer;
var
   ret : integer;

begin
   ret := DM.QueryOsoby.FieldByName('IDOSOBY').AsInteger;
   Result := ret;
end;

function TDlgOsoba.get_nazwisko() : String;
var
   ret : String;

begin
   ret := DM.QueryOsoby.FieldByName('NAZWISKO').AsString;
   Result := ret;
end;

function TDlgOsoba.get_dataur() : TDateTime;
var
   ret : TDateTime;
begin
   ret := DM.QueryOsoby.FieldByName('DATAUR').AsDateTime;
   Result := ret;
end;

function TDlgOsoba.get_mcowosc() : String;
var
   ret : String;

begin
   ret := DM.QueryOsoby.FieldByName('MCOWOSC').AsString;
   Result := ret;
end;

function TDlgOsoba.get_ulicainr() : String;
var
   ret : String;

begin
   ret := DM.QueryOsoby.FieldByName('ULICAINR').AsString;
   Result := ret;
end;

function TDlgOsoba.get_kodp : String;
var
   ret : String;

begin
   ret := DM.QueryOsoby.FieldByName('KODP').AsString;
   Result := ret;
end;

function TDlgOsoba.get_miasto() : String;
var
   ret : String;

begin
   ret := DM.QueryOsoby.FieldByName('MIASTO').AsString;
   Result := ret;
end;

function TDlgOsoba.get_pesel() : String;
var
   ret : String;

begin
   ret := DM.QueryOsoby.FieldByName('PESEL').AsString;
   Result := ret;
end;

procedure TDlgOsoba.set_idosoby(Value : Integer);
begin
   idosoby := value;
end;

procedure TDlgOsoba.set_nazwisko(Value: String);
begin
   meNazwisko.Text := Value;
end;

procedure TDlgOsoba.set_dataur(Value: TDateTime);
begin
   dtpDataur.Date := Value;
end;

procedure TDlgOsoba.set_mcowosc(Value: String);
begin
   meMcowosc.Text := Value;
end;

procedure TDlgOsoba.set_ulicainr(Value: String);
begin
   meUlicaINr.Text := Value;
end;

procedure TDlgOsoba.set_kodp(Value: String);
begin
   meKodp.Text := Value;
end;

procedure TDlgOsoba.set_miasto(Value: String);
begin
   meMiasto.Text := Value;
end;

procedure TDlgOsoba.set_pesel(Value: String);
begin
   mePesel.Text := Value;
end;


function TDlgOsoba.gets_idosoby() : Integer;
begin
   Result := idosoby;
end;

function TDlgOsoba.gets_nazwisko() : String;
begin
   Result := meNazwisko.Text;
end;

function TDlgOsoba.gets_imie() : String;
begin
   Result := meImie.Text;
end;

function TDlgOsoba.gets_dataur() : TDateTime;
begin
   Result := dtpDataUr.Date;
end;

function TDlgOsoba.gets_mcowosc() : String;
begin
   Result := meMcowosc.Text;
end;

function TDlgOsoba.gets_ulicainr() : String;
begin
   Result := meUlicaInr.text;
end;

function TDlgOsoba.gets_kodp : String;
begin
   Result := meKodp.Text;
end;

function TDlgOsoba.gets_miasto() : String;
begin
   Result := meMiasto.Text;
end;

function TDlgOsoba.gets_pesel() : String;
begin
   Result := mePesel.Text;
end;

procedure TDlgOsoba.BitBtn2Click(Sender: TObject);
begin
   with DM.IBQueryEDIT do begin
      Close();

      ParamByName('IDOSOBY').AsInteger := gets_idosoby();
      ParamByName('NAZWISKO').AsString := gets_nazwisko();
      ParamByName('IMIE').AsString     := gets_imie();
      ParamByName('DATAUR').AsDateTime := gets_dataur();
      ParamByName('MCOWOSC').AsString  := gets_mcowosc();
      ParamByName('ULICAINR').AsString := gets_ulicainr();
      ParamByName('KODP').AsString     := gets_kodp();
      ParamByName('MIASTO').AsString   := gets_miasto();
      ParamByName('PESEL').AsString    := gets_pesel();

      try
         DM.IBQueryEDIT.ExecSQL();
         DM.IBQueryEDIT.FetchAll();         
      finally
         DM.IBQueryEDIT.Close();
      end;
   end;
end;

end.
